/*!
 * 
 *  NOTE: This file is generated by webpack from ASRouterAdmin.jsx
 *  using the npm bundle task.
 *
 */
var ASRouterAdminRenderUtils;
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ASRouterUtils: () => (/* binding */ ASRouterUtils)
/* harmony export */ });
/* harmony import */ var _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */



const ASRouterUtils = {
  addListener(listener) {
    if (globalThis.ASRouterAddParentListener) {
      globalThis.ASRouterAddParentListener(listener);
    }
  },
  removeListener(listener) {
    if (globalThis.ASRouterRemoveParentListener) {
      globalThis.ASRouterRemoveParentListener(listener);
    }
  },
  sendMessage(action) {
    if (globalThis.ASRouterMessage) {
      return globalThis.ASRouterMessage(action);
    }
    throw new Error(`Unexpected call:\n${JSON.stringify(action, null, 3)}`);
  },
  blockById(id, options) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.BLOCK_MESSAGE_BY_ID,
      data: { id, ...options },
    });
  },
  modifyMessageJson(content) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.MODIFY_MESSAGE_JSON,
      data: { content },
    });
  },
  executeAction(button_action) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.USER_ACTION,
      data: button_action,
    });
  },
  unblockById(id) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.UNBLOCK_MESSAGE_BY_ID,
      data: { id },
    });
  },
  unblockAll() {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.UNBLOCK_ALL,
    });
  },
  resetGroupImpressions() {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.RESET_GROUPS_STATE,
    });
  },
  resetMessageImpressions() {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.RESET_MESSAGE_STATE,
    });
  },
  resetScreenImpressions() {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.RESET_SCREEN_IMPRESSIONS,
    });
  },
  blockBundle(bundle) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.BLOCK_BUNDLE,
      data: { bundle },
    });
  },
  unblockBundle(bundle) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.UNBLOCK_BUNDLE,
      data: { bundle },
    });
  },
  overrideMessage(id) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.OVERRIDE_MESSAGE,
      data: { id },
    });
  },
  editState(key, value) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.EDIT_STATE,
      data: { [key]: value },
    });
  },
  openPBWindow(content) {
    ASRouterUtils.sendMessage({
      type: "FORCE_PRIVATE_BROWSING_WINDOW",
      data: { message: { content } },
    });
  },
  sendTelemetry(ping) {
    return ASRouterUtils.sendMessage({
      type: _modules_ActorConstants_mjs__WEBPACK_IMPORTED_MODULE_0__.MESSAGE_TYPE_HASH.AS_ROUTER_TELEMETRY_USER_EVENT,
      data: ping,
    });
  },
  getPreviewEndpoint() {
    return null;
  },
};


/***/ }),
/* 2 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MESSAGE_TYPE_HASH: () => (/* binding */ MESSAGE_TYPE_HASH),
/* harmony export */   MESSAGE_TYPE_LIST: () => (/* binding */ MESSAGE_TYPE_LIST)
/* harmony export */ });
/* vim: set ts=2 sw=2 sts=2 et tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

const MESSAGE_TYPE_LIST = [
  "BLOCK_MESSAGE_BY_ID",
  "USER_ACTION",
  "IMPRESSION",
  "TRIGGER",
  // PB is Private Browsing
  "PBNEWTAB_MESSAGE_REQUEST",
  "DOORHANGER_TELEMETRY",
  "TOOLBAR_BADGE_TELEMETRY",
  "MOMENTS_PAGE_TELEMETRY",
  "INFOBAR_TELEMETRY",
  "SPOTLIGHT_TELEMETRY",
  "TOAST_NOTIFICATION_TELEMETRY",
  "MENU_MESSAGE_TELEMETRY",
  "NEWTAB_MESSAGE_TELEMETRY",
  "AS_ROUTER_TELEMETRY_USER_EVENT",

  // Admin types
  "ADMIN_CONNECT_STATE",
  "UNBLOCK_MESSAGE_BY_ID",
  "UNBLOCK_ALL",
  "BLOCK_BUNDLE",
  "UNBLOCK_BUNDLE",
  "DISABLE_PROVIDER",
  "ENABLE_PROVIDER",
  "EVALUATE_JEXL_EXPRESSION",
  "EXPIRE_QUERY_CACHE",
  "FORCE_ATTRIBUTION",
  "FORCE_PRIVATE_BROWSING_WINDOW",
  "OVERRIDE_MESSAGE",
  "MODIFY_MESSAGE_JSON",
  "RESET_PROVIDER_PREF",
  "SET_PROVIDER_USER_PREF",
  "RESET_GROUPS_STATE",
  "RESET_MESSAGE_STATE",
  "RESET_SCREEN_IMPRESSIONS",
  "EDIT_STATE",
];

const MESSAGE_TYPE_HASH = MESSAGE_TYPE_LIST.reduce((hash, value) => {
  hash[value] = value;
  return hash;
}, {});


/***/ }),
/* 3 */
/***/ ((module) => {

module.exports = React;

/***/ }),
/* 4 */
/***/ ((module) => {

module.exports = ReactDOM;

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SimpleHashRouter: () => (/* binding */ SimpleHashRouter)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */


class SimpleHashRouter extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
  constructor(props) {
    super(props);
    this.onHashChange = this.onHashChange.bind(this);
    this.state = {
      hash: __webpack_require__.g.location.hash
    };
  }
  onHashChange() {
    this.setState({
      hash: __webpack_require__.g.location.hash
    });
  }
  componentWillMount() {
    __webpack_require__.g.addEventListener("hashchange", this.onHashChange);
  }
  componentWillUnmount() {
    __webpack_require__.g.removeEventListener("hashchange", this.onHashChange);
  }
  render() {
    const [, ...routes] = this.state.hash.split("-");
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(this.props.children, {
      location: {
        hash: this.state.hash,
        routes
      }
    });
  }
}

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CopyButton: () => (/* binding */ CopyButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */


const CopyButton = ({
  className,
  label,
  copiedLabel,
  inputSelector,
  transformer,
  ...props
}) => {
  const [copied, setCopied] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const timeout = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const onClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    let text = document.querySelector(inputSelector).value;
    if (transformer) {
      text = transformer(text);
    }
    navigator.clipboard.writeText(text);
    clearTimeout(timeout.current);
    setCopied(true);
    timeout.current = setTimeout(() => setCopied(false), 1500);
  }, [inputSelector, transformer]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", _extends({
    className: className,
    onClick: () => onClick()
  }, props), copied && copiedLabel || label);
};

/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ImpressionsSection: () => (/* binding */ ImpressionsSection)
/* harmony export */ });
/* harmony import */ var _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */



const stringify = json => JSON.stringify(json, null, 2);
const ImpressionsSection = ({
  messageImpressions,
  groupImpressions,
  screenImpressions
}) => {
  const handleSaveMessageImpressions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(newImpressions => {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.editState("messageImpressions", newImpressions);
  }, []);
  const handleSaveGroupImpressions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(newImpressions => {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.editState("groupImpressions", newImpressions);
  }, []);
  const handleSaveScreenImpressions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(newImpressions => {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.editState("screenImpressions", newImpressions);
  }, []);
  const handleResetMessageImpressions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "RESET_MESSAGE_STATE"
    });
  }, []);
  const handleResetGroupImpressions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "RESET_GROUPS_STATE"
    });
  }, []);
  const handleResetScreenImpressions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "RESET_SCREEN_IMPRESSIONS"
    });
  }, []);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "impressions-section"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ImpressionsItem, {
    impressions: messageImpressions,
    label: "Message Impressions",
    description: "Message impressions are stored in an object, where each key is a message ID and each value is an array of timestamps. They are cleaned up when a message with that ID stops existing in ASRouter state (such as at the end of an experiment).",
    onSave: handleSaveMessageImpressions,
    onReset: handleResetMessageImpressions
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ImpressionsItem, {
    impressions: groupImpressions,
    label: "Group Impressions",
    description: "Group impressions are stored in an object, where each key is a group ID and each value is an array of timestamps. They are never cleaned up.",
    onSave: handleSaveGroupImpressions,
    onReset: handleResetGroupImpressions
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ImpressionsItem, {
    impressions: screenImpressions,
    label: "Screen Impressions",
    description: "Screen impressions are stored in an object, where each key is a screen ID and each value is the most recent timestamp that screen was shown. They are never cleaned up.",
    onSave: handleSaveScreenImpressions,
    onReset: handleResetScreenImpressions
  }));
};
const ImpressionsItem = ({
  impressions,
  label,
  description,
  validator,
  onSave,
  onReset
}) => {
  const [json, setJson] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(stringify(impressions));
  const modified = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(false);
  const isValidJson = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(text => {
    try {
      JSON.parse(text);
      return validator ? validator(text) : true;
    } catch (e) {
      return false;
    }
  }, [validator]);
  const jsonIsInvalid = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => !isValidJson(json), [json, isValidJson]);
  const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(e => {
    setJson(e.target.value);
    modified.current = true;
  }, []);
  const handleSave = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    if (jsonIsInvalid) {
      return;
    }
    const newImpressions = JSON.parse(json);
    modified.current = false;
    onSave(newImpressions);
  }, [json, jsonIsInvalid, onSave]);
  const handleReset = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    modified.current = false;
    onReset();
  }, [onReset]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!modified.current) {
      setJson(stringify(impressions));
    }
  }, [impressions]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "impressions-item"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
    className: "impressions-category"
  }, label), description ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", {
    className: "impressions-description"
  }, description) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "impressions-inner-box"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "impressions-buttons"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
    className: "button primary",
    disabled: jsonIsInvalid,
    onClick: handleSave
  }, "Save"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
    className: "button reset",
    onClick: handleReset
  }, "Reset")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "impressions-editor"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("textarea", {
    rows: "15",
    value: json,
    onChange: handleChange
  }))));
};

/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ASRouterAdmin: () => (/* binding */ ASRouterAdmin),
/* harmony export */   ASRouterAdminInner: () => (/* binding */ ASRouterAdminInner),
/* harmony export */   ToggleMessageJSON: () => (/* binding */ ToggleMessageJSON),
/* harmony export */   renderASRouterAdmin: () => (/* binding */ renderASRouterAdmin),
/* harmony export */   toBinary: () => (/* binding */ toBinary)
/* harmony export */ });
/* harmony import */ var _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _SimpleHashRouter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5);
/* harmony import */ var _CopyButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6);
/* harmony import */ var _ImpressionsSection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */








// Convert a UTF-8 string to a string in which only one byte of each
// 16-bit unit is occupied. This is necessary to comply with `btoa` API constraints.
function toBinary(string) {
  const codeUnits = new Uint16Array(string.length);
  for (let i = 0; i < codeUnits.length; i++) {
    codeUnits[i] = string.charCodeAt(i);
  }
  return btoa(String.fromCharCode(...Array.from(new Uint8Array(codeUnits.buffer))));
}
function relativeTime(timestamp) {
  if (!timestamp) {
    return "";
  }
  const seconds = Math.floor((Date.now() - timestamp) / 1000);
  const minutes = Math.floor((Date.now() - timestamp) / 60000);
  if (seconds < 2) {
    return "just now";
  } else if (seconds < 60) {
    return `${seconds} seconds ago`;
  } else if (minutes === 1) {
    return "1 minute ago";
  } else if (minutes < 600) {
    return `${minutes} minutes ago`;
  }
  return new Date(timestamp).toLocaleString();
}
class ToggleMessageJSON extends (react__WEBPACK_IMPORTED_MODULE_1___default().PureComponent) {
  constructor(props) {
    super(props);
    this.handleClick = this.handleClick.bind(this);
  }
  handleClick() {
    this.props.toggleJSON(this.props.msgId);
  }
  render() {
    let direction = this.props.isCollapsed ? "forward" : "down";
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "clearButton",
      onClick: this.handleClick
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: `icon small icon-arrowhead-${direction}`
    }));
  }
}
class ASRouterAdminInner extends (react__WEBPACK_IMPORTED_MODULE_1___default().PureComponent) {
  constructor(props) {
    super(props);
    this.handleEnabledToggle = this.handleEnabledToggle.bind(this);
    this.handleUserPrefToggle = this.handleUserPrefToggle.bind(this);
    this.onChangeFilters = this.onChangeFilters.bind(this);
    this.onClearFilters = this.onClearFilters.bind(this);
    this.unblockAll = this.unblockAll.bind(this);
    this.resetAllJSON = this.resetAllJSON.bind(this);
    this.handleExpressionEval = this.handleExpressionEval.bind(this);
    this.onChangeTargetingParameters = this.onChangeTargetingParameters.bind(this);
    this.onChangeAttributionParameters = this.onChangeAttributionParameters.bind(this);
    this.setAttribution = this.setAttribution.bind(this);
    this.onCopyTargetingParams = this.onCopyTargetingParams.bind(this);
    this.onNewTargetingParams = this.onNewTargetingParams.bind(this);
    this.resetMessageState = this.resetMessageState.bind(this);
    this.toggleJSON = this.toggleJSON.bind(this);
    this.toggleAllMessages = this.toggleAllMessages.bind(this);
    this.resetGroupImpressions = this.resetGroupImpressions.bind(this);
    this.onMessageFromParent = this.onMessageFromParent.bind(this);
    this.setStateFromParent = this.setStateFromParent.bind(this);
    this.setState = this.setState.bind(this);
    this.state = {
      filterGroups: [],
      filterProviders: [],
      filterTemplates: [],
      filtersCollapsed: true,
      collapsedMessages: [],
      modifiedMessages: [],
      messageBlockList: [],
      evaluationStatus: {},
      stringTargetingParameters: null,
      newStringTargetingParameters: null,
      copiedToClipboard: false,
      attributionParameters: {
        source: "addons.mozilla.org",
        medium: "referral",
        campaign: "non-fx-button",
        content: `rta:${btoa("uBlock0@raymondhill.net")}`,
        experiment: "ua-onboarding",
        variation: "chrome",
        ua: "Google Chrome 123",
        dltoken: "00000000-0000-0000-0000-000000000000"
      }
    };
  }
  onMessageFromParent({
    type,
    data
  }) {
    // These only exists due to onPrefChange events in ASRouter
    switch (type) {
      case "UpdateAdminState":
        {
          this.setStateFromParent(data);
          break;
        }
    }
  }
  async setStateFromParent(data) {
    await this.setState(data);
    if (!this.state.stringTargetingParameters) {
      const stringTargetingParameters = {};
      for (const param of Object.keys(data.targetingParameters)) {
        stringTargetingParameters[param] = JSON.stringify(data.targetingParameters[param], null, 2);
      }
      await this.setState({
        stringTargetingParameters
      });
    }
  }
  componentWillMount() {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.addListener(this.onMessageFromParent);
    const endpoint = _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.getPreviewEndpoint();
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "ADMIN_CONNECT_STATE",
      data: {
        endpoint
      }
    }).then(this.setStateFromParent);
  }
  componentWillUnmount() {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.removeListener(this.onMessageFromParent);
  }
  handleBlock(msg) {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.blockById(msg.id);
  }
  handleUnblock(msg) {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.unblockById(msg.id);
  }
  resetJSON(msg) {
    // reset the displayed JSON for the given message
    let textarea = document.getElementById(`${msg.id}-textarea`);
    textarea.value = JSON.stringify(msg, null, 2);
    textarea.classList.remove("errorState");
    // remove the message from the list of modified IDs
    let index = this.state.modifiedMessages.indexOf(msg.id);
    this.setState(prevState => ({
      modifiedMessages: [...prevState.modifiedMessages.slice(0, index), ...prevState.modifiedMessages.slice(index + 1)]
    }));
  }
  resetAllJSON() {
    // reset the displayed JSON for each modified message
    for (const msgId of this.state.modifiedMessages) {
      const msg = this.state.messages.find(m => m.id === msgId);
      const textarea = document.getElementById(`${msgId}-textarea`);
      if (textarea) {
        textarea.value = JSON.stringify(msg, null, 2);
        textarea.classList.remove("errorState");
      }
    }
    this.setState({
      modifiedMessages: []
    });
  }
  showMessage(msg) {
    if (msg.template === "pb_newtab") {
      _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.openPBWindow(msg.content);
    } else {
      _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.overrideMessage(msg.id).then(state => this.setStateFromParent(state));
    }
  }
  async resetMessageState() {
    await Promise.all([_asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.resetMessageImpressions(), _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.resetGroupImpressions(), _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.resetScreenImpressions(), _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.unblockAll()]);
    let data = await _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "ADMIN_CONNECT_STATE",
      data: {
        endpoint: _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.getPreviewEndpoint()
      }
    });
    await this.setStateFromParent(data);
  }
  expireCache() {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "EXPIRE_QUERY_CACHE"
    });
  }
  resetPref() {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "RESET_PROVIDER_PREF"
    });
  }
  resetGroupImpressions() {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.resetGroupImpressions().then(this.setStateFromParent);
  }
  resetMessageImpressions() {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.resetMessageImpressions().then(this.setStateFromParent);
  }
  handleExpressionEval() {
    const context = {};
    for (const param of Object.keys(this.state.stringTargetingParameters)) {
      const value = this.state.stringTargetingParameters[param];
      context[param] = value ? JSON.parse(value) : null;
    }
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "EVALUATE_JEXL_EXPRESSION",
      data: {
        expression: this.refs.expressionInput.value || "undefined",
        context
      }
    }).then(this.setStateFromParent);
  }
  onChangeTargetingParameters(event) {
    const {
      name: eventName
    } = event.target;
    const {
      value
    } = event.target;
    let targetingParametersError = null;
    try {
      JSON.parse(value);
      event.target.classList.remove("errorState");
    } catch (e) {
      console.error(`Error parsing value of parameter ${eventName}`);
      event.target.classList.add("errorState");
      targetingParametersError = {
        id: eventName
      };
    }
    this.setState(({
      stringTargetingParameters
    }) => {
      const updatedParameters = {
        ...stringTargetingParameters
      };
      updatedParameters[eventName] = value;
      return {
        copiedToClipboard: false,
        evaluationStatus: {},
        stringTargetingParameters: updatedParameters,
        targetingParametersError
      };
    });
  }
  unblockAll() {
    return _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.unblockAll().then(this.setStateFromParent);
  }
  async handleEnabledToggle(event) {
    const provider = this.state.providerPrefs.find(p => p.id === event.target.dataset.provider);
    const userPrefInfo = this.state.userPrefs;
    const isUserEnabled = provider.id in userPrefInfo ? userPrefInfo[provider.id] : true;
    const isSystemEnabled = provider.enabled;
    const isEnabling = event.target.checked;
    if (isEnabling) {
      if (!isUserEnabled) {
        await _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
          type: "SET_PROVIDER_USER_PREF",
          data: {
            id: provider.id,
            value: true
          }
        });
      }
      if (!isSystemEnabled) {
        await _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
          type: "ENABLE_PROVIDER",
          data: provider.id
        });
      }
    } else {
      await _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
        type: "DISABLE_PROVIDER",
        data: provider.id
      });
    }
    this.setState({
      filterProviders: []
    });
  }
  handleUserPrefToggle(event) {
    const action = {
      type: "SET_PROVIDER_USER_PREF",
      data: {
        id: event.target.dataset.provider,
        value: event.target.checked
      }
    };
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage(action);
    this.setState({
      filterProviders: []
    });
  }
  onChangeFilters(event) {
    // this function handles both provider filter and group filter. the checkbox
    // will have dataset.provider if it's a provider checkbox, and dataset.group
    // if it's a group checkbox.
    let stateKey;
    let itemValue;
    let {
      checked
    } = event.target;
    if (event.target.dataset.provider) {
      stateKey = "filterProviders";
      itemValue = event.target.dataset.provider;
    } else if (event.target.dataset.group) {
      stateKey = "filterGroups";
      itemValue = event.target.dataset.group;
    } else if (event.target.dataset.template) {
      stateKey = "filterTemplates";
      itemValue = event.target.dataset.template;
    } else {
      return;
    }
    this.setState(prevState => {
      let newValue;
      if (checked) {
        newValue = prevState[stateKey].includes(itemValue) ? prevState[stateKey] : prevState[stateKey].concat(itemValue);
      } else {
        newValue = prevState[stateKey].filter(item => item !== itemValue);
      }
      return {
        [stateKey]: newValue
      };
    });
  }
  onClearFilters() {
    this.setState({
      filterProviders: [],
      filterGroups: [],
      filterTemplates: []
    });
  }

  // Simulate a copy event that sets to clipboard all targeting paramters and values
  onCopyTargetingParams() {
    const stringTargetingParameters = {
      ...this.state.stringTargetingParameters
    };
    for (const key of Object.keys(stringTargetingParameters)) {
      // If the value is not set the parameter will be lost when we stringify
      if (stringTargetingParameters[key] === undefined) {
        stringTargetingParameters[key] = null;
      }
    }
    const setClipboardData = e => {
      e.preventDefault();
      e.clipboardData.setData("text", JSON.stringify(stringTargetingParameters, null, 2));
      document.removeEventListener("copy", setClipboardData);
      this.setState({
        copiedToClipboard: true
      });
    };
    document.addEventListener("copy", setClipboardData);
    document.execCommand("copy");
  }
  onNewTargetingParams(event) {
    this.setState({
      newStringTargetingParameters: event.target.value
    });
    event.target.classList.remove("errorState");
    this.refs.targetingParamsEval.innerText = "";
    try {
      const stringTargetingParameters = JSON.parse(event.target.value);
      this.setState({
        stringTargetingParameters
      });
    } catch (e) {
      event.target.classList.add("errorState");
      this.refs.targetingParamsEval.innerText = e.message;
    }
  }
  toggleJSON(msgId) {
    if (this.state.collapsedMessages.includes(msgId)) {
      let index = this.state.collapsedMessages.indexOf(msgId);
      this.setState(prevState => ({
        collapsedMessages: [...prevState.collapsedMessages.slice(0, index), ...prevState.collapsedMessages.slice(index + 1)]
      }));
    } else {
      this.setState(prevState => ({
        collapsedMessages: prevState.collapsedMessages.concat(msgId)
      }));
    }
  }
  onMessageChanged(msgId) {
    if (!this.state.modifiedMessages.includes(msgId)) {
      this.setState(prevState => ({
        modifiedMessages: prevState.modifiedMessages.concat(msgId)
      }));
    }
  }
  renderMessageItem(msg) {
    const isBlockedByGroup = this.state.groups.filter(group => msg.groups.includes(group.id)).some(group => !group.enabled);
    const msgProvider = this.state.providers.find(provider => provider.id === msg.provider) || {};
    const isProviderExcluded = msgProvider.exclude && msgProvider.exclude.includes(msg.id);
    const isMessageBlocked = this.state.messageBlockList.includes(msg.id) || this.state.messageBlockList.includes(msg.campaign);
    const isBlocked = isMessageBlocked || isBlockedByGroup || isProviderExcluded;
    const impressions = this.state.messageImpressions[msg.id] ? this.state.messageImpressions[msg.id].length : 0;
    const isCollapsed = this.state.collapsedMessages.includes(msg.id);
    const isModified = this.state.modifiedMessages.includes(msg.id);
    const aboutMessagePreviewSupported = ["infobar", "spotlight", "cfr_doorhanger", "feature_callout", "pb_newtab"].includes(msg.template);
    let itemClassName = "message-item";
    if (isBlocked) {
      itemClassName += " blocked";
    }
    let messageStats = [];
    let messageStatsString;
    if (impressions) {
      messageStats.push(`${impressions} impressions`);
    }
    if (isMessageBlocked) {
      messageStats.push("message blocked");
    } else if (isBlockedByGroup) {
      messageStats.push("message group blocked");
    } else if (isProviderExcluded) {
      messageStats.push("excluded by provider");
    }
    if (messageStats.length) {
      messageStatsString = `(${messageStats.join(", ")})`;
    }
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: itemClassName,
      key: `${msg.id}-${msg.provider}`
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "button-box baseline"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: "message-id monospace"
    }, msg.id), " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: "message-stats small-text"
    }, messageStatsString)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "button-box"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ToggleMessageJSON, {
      msgId: `${msg.id}`,
      toggleJSON: this.toggleJSON,
      isCollapsed: isCollapsed
    }),
    // eslint-disable-next-line no-nested-ternary
    isBlocked ? null : isModified ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "restore",
      onClick: () => this.resetJSON(msg)
    }, "Reset") : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "primary show",
      onClick: () => this.showMessage(msg)
    }, "Show"), isBlocked || !isModified ? null : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "primary modify",
      onClick: () => this.modifyJson(msg)
    }, "Modify"), aboutMessagePreviewSupported ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_CopyButton__WEBPACK_IMPORTED_MODULE_4__.CopyButton, {
      transformer: text => `about:messagepreview?json=${encodeURIComponent(toBinary(text))}`,
      label: "Share",
      copiedLabel: "Copied!",
      inputSelector: `#${msg.id}-textarea`,
      className: "share"
    }) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: `button${isBlocked ? " primary" : ""}`,
      onClick: () => isBlocked ? this.handleUnblock(msg) : this.handleBlock(msg)
    }, isBlocked ? "Unblock" : "Block")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("pre", {
      className: isCollapsed ? "collapsed" : "expanded"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("textarea", {
      id: `${msg.id}-textarea`,
      name: msg.id,
      className: "message-textarea",
      disabled: isBlocked,
      rows: "30",
      onChange: event => {
        try {
          JSON.parse(event.target.value);
          event.target.classList.remove("errorState");
        } catch (e) {
          event.target.classList.add("errorState");
        }
        this.onMessageChanged(msg.id);
      },
      spellCheck: "false"
    }, JSON.stringify(msg, null, 2))));
  }
  modifyJson(content) {
    const message = JSON.parse(document.getElementById(`${content.id}-textarea`).value);
    if (message.template === "pb_newtab") {
      _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.openPBWindow(message.content);
    } else {
      _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.modifyMessageJson(message).then(state => {
        this.setStateFromParent(state);
      });
    }
  }
  toggleAllMessages(messagesToShow) {
    if (this.state.collapsedMessages.length) {
      this.setState({
        collapsedMessages: []
      });
    } else {
      Array.prototype.forEach.call(messagesToShow, msg => {
        this.setState(prevState => ({
          collapsedMessages: prevState.collapsedMessages.concat(msg.id)
        }));
      });
    }
  }
  filterMessages() {
    let messages = [...this.state.messages];
    if (this.state.filterProviders.length) {
      messages = messages.filter(msg => this.state.filterProviders.includes(msg.provider));
    }
    if (this.state.filterGroups.length) {
      messages = messages.filter(msg => msg.groups?.some(group => this.state.filterGroups.includes(group)) || !msg.groups?.length && this.state.filterGroups.includes("none"));
    }
    if (this.state.filterTemplates.length) {
      messages = messages.filter(msg => this.state.filterTemplates.includes(msg.template));
    }
    return messages;
  }
  renderMessages() {
    if (!this.state.messages) {
      return null;
    }
    const messagesToShow = this.filterMessages();
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", {
      className: "helpLink"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: "icon icon-small-spacer icon-info"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("ul", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", null, "To modify a message, change the JSON and click 'Modify' to see your changes."), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", null, "Click \"Reset\" to restore the JSON to the original."), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", null, "Click \"Share\" to copy a link to the clipboard that can be used to preview the message by opening the link in Nightly/local builds."))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "button-box"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "small no-margins",
      onClick: () => this.toggleAllMessages(messagesToShow)
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: `icon small icon-small-spacer icon-arrowhead-${this.state.collapsedMessages.length ? "forward" : "down"}`
    }), this.state.collapsedMessages.length ? "Expand all" : "Collapse all"), this.state.modifiedMessages.length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "small no-margins messages-reset",
      onClick: this.resetAllJSON
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: "icon small icon-small-spacer icon-undo"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "Reset all JSON")) : null, this.state.messageBlockList.length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "small no-margins unblock-all",
      onClick: this.unblockAll
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "Unblock all")) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "small no-margins",
      onClick: this.resetMessageState
    }, "Reset FxMS state")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "messages-list"
    }, messagesToShow.map(msg => this.renderMessageItem(msg))));
  }
  renderFilters() {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "filters"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "button-box"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "small no-margins",
      onClick: () => this.setState(prevState => ({
        filtersCollapsed: !prevState.filtersCollapsed
      }))
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: `icon small icon-small-spacer icon-arrowhead-${this.state.filtersCollapsed ? "forward" : "down"}`
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "Filters")), this.state.filterProviders.length || this.state.filterGroups.length || this.state.filterTemplates.length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "small no-margins",
      onClick: this.onClearFilters
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: "icon small icon-small-spacer icon-dismiss"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "Clear")) : null), this.state.filtersCollapsed ? null : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "row"
    }, this.state.messages ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h3", null, "Templates"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "col"
    }, this.state.messages.map(message => message.template).filter(
    // eslint-disable-next-line no-shadow
    (value, index, self) => self.indexOf(value) === index).map(template => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("label", {
      key: template
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      type: "checkbox",
      "data-template": template,
      checked: this.state.filterTemplates.includes(template),
      onChange: this.onChangeFilters
    }), template)))) : null, this.state.groups ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h3", null, "Groups"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "col"
    }, this.state.groups.map(group => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("label", {
      key: group.id
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      type: "checkbox",
      "data-group": group.id,
      checked: this.state.filterGroups.includes(group.id),
      onChange: this.onChangeFilters
    }), group.id)))) : null, this.state.providers ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h3", null, "Providers"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "col"
    }, this.state.providers.map(provider => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("label", {
      key: provider.id
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      type: "checkbox",
      "data-provider": provider.id,
      checked: this.state.filterProviders.includes(provider.id),
      onChange: this.onChangeFilters
    }), provider.id)))) : null));
  }
  renderProviders() {
    const providersConfig = this.state.providerPrefs;
    const providerInfo = this.state.providers;
    const userPrefInfo = this.state.userPrefs;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("table", {
      className: "bordered-table",
      id: "providers-table"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("thead", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      className: "fixed-width"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      className: "no-wrap"
    }, "Provider"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Source"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      className: "no-wrap"
    }, "Last Updated"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tbody", null, providersConfig.map((provider, i) => {
      const isTestProvider = provider.id.includes("_local_testing");
      const info = providerInfo.find(p => p.id === provider.id) || {};
      const isUserEnabled = provider.id in userPrefInfo ? userPrefInfo[provider.id] : true;
      const isSystemEnabled = isTestProvider || provider.enabled;
      let label = "local";
      if (provider.type === "remote") {
        label = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "endpoint (", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
          className: "small-text",
          target: "_blank",
          href: info.url,
          rel: "noopener noreferrer"
        }, info.url), ")");
      } else if (provider.type === "remote-settings") {
        label = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "remote settings (", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
          className: "small-text",
          target: "_blank",
          href: `https://firefox.settings.services.mozilla.com/v1/buckets/main/collections/${provider.collection}/records`,
          rel: "noopener noreferrer"
        }, provider.collection), ")");
      } else if (provider.type === "remote-experiments") {
        label = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "remote settings (", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
          className: "small-text",
          target: "_blank",
          href: "https://firefox.settings.services.mozilla.com/v1/buckets/main/collections/nimbus-desktop-experiments/records",
          rel: "noopener noreferrer"
        }, "nimbus-desktop-experiments"), ")");
      }
      let reasonsDisabled = [];
      if (!isSystemEnabled) {
        reasonsDisabled.push("system pref");
      }
      if (!isUserEnabled) {
        reasonsDisabled.push("user pref");
      }
      if (reasonsDisabled.length) {
        label = `disabled via ${reasonsDisabled.join(", ")}`;
      }
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", {
        key: i
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, isTestProvider ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
        type: "checkbox",
        disabled: true,
        readOnly: true,
        checked: true
      }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
        type: "checkbox",
        "data-provider": provider.id,
        checked: isUserEnabled && isSystemEnabled,
        onChange: this.handleEnabledToggle
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, provider.id), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
        className: `sourceLabel${isUserEnabled && isSystemEnabled ? "" : " isDisabled"}`
      }, label)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
        className: "no-wrap"
      }, info.lastUpdated ? relativeTime(info.lastUpdated) : ""));
    })));
  }
  renderMessageGroups() {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("table", {
      className: "bordered-table",
      id: "groups-table"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("thead", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      className: "fixed-width"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      className: "no-wrap"
    }, "Group"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      className: "no-wrap"
    }, "Impressions"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Frequency caps"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "User preferences"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tbody", null, this.state.groups && this.state.groups.map(({
      id,
      enabled,
      frequency,
      userPreferences = []
    }) => {
      let frequencyCaps = [];
      if (!frequency) {
        frequencyCaps.push("n/a");
      } else {
        if (frequency.custom) {
          for (let f of frequency.custom) {
            let {
              period
            } = f;
            let periodString = "";
            if (period >= 2419200000 && period % 2419200000 < 604800000) {
              let months = Math.round(period / 2419200000);
              periodString = months === 1 ? "/month" : ` in ${months}mos`;
            } else if (period >= 604800000 && period % 604800000 < 86400000) {
              let weeks = Math.round(period / 604800000);
              periodString = weeks === 1 ? "/week" : ` in ${weeks}wks`;
            } else if (period >= 86400000 && period % 86400000 < 3600000) {
              let days = Math.round(period / 86400000);
              periodString = days === 1 ? "/day" : ` in ${days}d`;
            } else {
              periodString = ` in ${period}ms`;
            }
            frequencyCaps.push(`${f.cap}${periodString}`);
          }
        }
        if ("lifetime" in frequency) {
          frequencyCaps.push(`${frequency.lifetime}/lifetime`);
        }
      }
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", {
        key: id
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
        className: "fixed-width"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
        type: "checkbox",
        checked: enabled,
        disabled: true
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
        className: "no-wrap"
      }, id), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
        className: "no-wrap"
      }, this._getGroupImpressionsCount(id, frequency)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, frequencyCaps.join(", "))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
        className: "monospace small-text"
      }, userPreferences.join(", "))));
    })));
  }
  renderTargetingParameters() {
    // There was no error and the result is truthy
    const success = this.state.evaluationStatus.success && !!this.state.evaluationStatus.result;
    const result = JSON.stringify(this.state.evaluationStatus.result, null, 2) || "";
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("table", {
      className: "targeting-table"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tbody", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      colSpan: "2"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Evaluate JEXL expression"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", {
      className: "jexl-evaluator-row"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      colSpan: "2"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "jexl-evaluator"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "jexl-evaluator-textareas"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "jexl-evaluator-input"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("textarea", {
      className: "monospace no-margins",
      ref: "expressionInput",
      rows: "10",
      cols: "60",
      placeholder: "Evaluate JEXL expressions and mock parameters by changing their values below",
      spellCheck: "false"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "primary no-margins",
      onClick: this.handleExpressionEval
    }, "Evaluate")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "jexl-evaluator-output"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("textarea", {
      className: "monospace no-margins",
      readOnly: true,
      rows: "10",
      cols: "40",
      placeholder: "<evaluation result>",
      value: result,
      spellCheck: "false"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: "jexl-status"
    }, "Status: ", success ? "✅" : "❌")))))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      colSpan: "2"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Modify targeting parameters"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "no-margins",
      onClick: this.onCopyTargetingParams,
      disabled: this.state.copiedToClipboard
    }, this.state.copiedToClipboard ? "Parameters copied!" : "Copy parameters"))), this.state.stringTargetingParameters && Object.keys(this.state.stringTargetingParameters).map((param, i) => {
      const value = this.state.stringTargetingParameters[param];
      const errorState = this.state.targetingParametersError && this.state.targetingParametersError.id === param;
      const largeEditor = value?.length > 30 || value?.match(/[\nR]/);
      const className = `monospace no-margins targeting-editor${errorState ? " errorState" : ""}${largeEditor ? " large" : " small"}`;
      const inputComp = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("textarea", {
        name: param,
        className: className,
        value: value,
        rows: largeEditor ? "10" : "1",
        cols: largeEditor ? "60" : "28",
        onChange: this.onChangeTargetingParameters,
        spellCheck: "false"
      });
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", {
        key: i
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, param), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, inputComp));
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      colSpan: "2"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Attribution parameters"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      colSpan: "2"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", null, "This forces the browser to set some attribution parameters, useful for testing the Return To AMO feature. Clicking on 'Force Attribution', with the default values in each field, will demo the Return To AMO flow with the addon called 'uBlock Origin'. If you wish to try different attribution parameters, enter them in the text boxes. If you wish to try a different addon with the Return To AMO flow, make sure the 'content' text box has a string that is 'rta:base64(addonID)', the base64 string of the addonID prefixed with 'rta:'. The addon must currently be a recommended addon on AMO. Then click 'Force Attribution'. Clicking on 'Force Attribution' with blank text boxes reset attribution data."))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Source"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "source",
      placeholder: "addons.mozilla.org",
      value: this.state.attributionParameters.source,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Medium"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "medium",
      placeholder: "referral",
      value: this.state.attributionParameters.medium,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Campaign"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "campaign",
      placeholder: "non-fx-button",
      value: this.state.attributionParameters.campaign,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Content"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "content",
      placeholder: `rta:${btoa("uBlock0@raymondhill.net")}`,
      value: this.state.attributionParameters.content,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Experiment"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "experiment",
      placeholder: "ua-onboarding",
      value: this.state.attributionParameters.experiment,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Variation"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "variation",
      placeholder: "chrome",
      value: this.state.attributionParameters.variation,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "User Agent"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "ua",
      placeholder: "Google Chrome 123",
      value: this.state.attributionParameters.ua,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, "Download Token"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
      className: "monospace no-margins",
      type: "text",
      size: "36",
      name: "dltoken",
      placeholder: "00000000-0000-0000-0000-000000000000",
      value: this.state.attributionParameters.dltoken,
      onChange: this.onChangeAttributionParameters
    }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      colSpan: "2"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
      className: "primary no-margins",
      onClick: this.setAttribution
    }, "Force attribution")))));
  }
  onChangeAttributionParameters(event) {
    const {
      name: eventName,
      value
    } = event.target;
    this.setState(({
      attributionParameters
    }) => {
      const updatedParameters = {
        ...attributionParameters
      };
      updatedParameters[eventName] = value;
      return {
        attributionParameters: updatedParameters
      };
    });
  }
  setAttribution() {
    _asrouter_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.ASRouterUtils.sendMessage({
      type: "FORCE_ATTRIBUTION",
      data: this.state.attributionParameters
    }).then(this.setStateFromParent);
  }
  _getGroupImpressionsCount(id, frequency) {
    if (frequency) {
      return this.state.groupImpressions[id] ? this.state.groupImpressions[id].length : 0;
    }
    return "n/a";
  }
  renderErrorMessage({
    id,
    errors
  }) {
    const providerId = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", {
      rowSpan: errors.length
    }, id);
    // .reverse() so that the last error (most recent) is first
    return errors.map(({
      error,
      timestamp
    }, cellKey) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", {
      key: cellKey
    }, cellKey === errors.length - 1 ? providerId : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, error.message), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("td", null, relativeTime(timestamp)))).reverse();
  }
  renderErrors() {
    const providersWithErrors = this.state.providers && this.state.providers.filter(p => p.errors && p.errors.length);
    if (providersWithErrors && providersWithErrors.length) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("table", {
        className: "errorReporting"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("thead", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tr", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("th", null, "Provider"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("th", null, "Message"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("th", null, "Timestamp"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("tbody", null, providersWithErrors.map(this.renderErrorMessage)));
    }
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", null, "No errors");
  }
  renderSection() {
    const [section] = this.props.location.routes;
    switch (section) {
      case "targeting":
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Targeting utilities"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
          className: "button-box"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
          className: "no-margins",
          onClick: this.expireCache,
          title: "Values are cached for some targeting attributes (see ASRouterTargeting). This expires the query cache."
        }, "Expire cache")), this.renderTargetingParameters());
      case "impressions":
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Impressions"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ImpressionsSection__WEBPACK_IMPORTED_MODULE_5__.ImpressionsSection, {
          messageImpressions: this.state.messageImpressions,
          groupImpressions: this.state.groupImpressions,
          screenImpressions: this.state.screenImpressions
        }));
      case "errors":
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "ASRouter errors"), this.renderErrors());
      default:
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Message providers", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
          className: "small",
          title: "Restore all provider settings that ship with Abrowser",
          onClick: this.resetPref
        }, "Restore default prefs")), this.state.providers ? this.renderProviders() : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Message groups", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
          className: "small",
          onClick: this.resetGroupImpressions
        }, "Reset group impressions")), this.state.groups ? this.renderMessageGroups() : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h2", null, "Messages", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("button", {
          className: "small",
          onClick: this.resetMessageImpressions
        }, "Reset message impressions")), this.renderFilters(), this.renderMessages());
    }
  }
  render() {
    if (!this.state.devtoolsEnabled) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
        className: "asrouter-admin"
      }, "You must enable the ASRouter Admin page by setting", " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("code", null, "browser.newtabpage.activity-stream.asrouter.devtoolsEnabled"), " ", "to ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("code", null, "true"), " and then reloading this page.");
    }
    const [section] = this.props.location.routes;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "asrouter-admin"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("aside", {
      className: "sidebar"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("ul", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
      href: "#devtools",
      className: "category",
      "data-selected": section ? null : ""
    }, "General")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
      href: "#devtools-targeting",
      className: "category",
      "data-selected": section === "targeting" ? "" : null
    }, "Targeting")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
      href: "#devtools-impressions",
      className: "category",
      "data-selected": section === "impressions" ? "" : null
    }, "Impressions")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
      href: "#devtools-errors",
      className: "category",
      "data-selected": section === "errors" ? "" : null
    }, "Errors")))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("main", {
      className: "main-panel"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("h1", null, "ASRouter Admin"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", {
      className: "helpLink"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
      className: "icon icon-small-spacer icon-info"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", null, "Need help using these tools? Check out our", " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("a", {
      target: "blank",
      href: "https://firefox-source-docs.mozilla.org/browser/components/asrouter/docs/debugging-docs.html"
    }, "documentation"))), this.renderSection()));
  }
}
const ASRouterAdmin = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_SimpleHashRouter__WEBPACK_IMPORTED_MODULE_3__.SimpleHashRouter, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ASRouterAdminInner, props));
function renderASRouterAdmin() {
  react_dom__WEBPACK_IMPORTED_MODULE_2___default().render(/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ASRouterAdmin, null), document.getElementById("root"));
}
})();

ASRouterAdminRenderUtils = __webpack_exports__;
/******/ })()
;