/* SPDX-License-Identifier: LGPL-2.1-or-later */
#pragma once

#include <stdbool.h>

#include "hashmap.h"
#include "json.h"

typedef struct Link Link;
typedef struct Manager Manager;

int addresses_append_json(Link *link, bool serializing, JsonVariant **v);
int routes_append_json(Set *routes, bool serializing, JsonVariant **v);
int link_build_json(Link *link, JsonVariant **ret);
int manager_build_json(Manager *manager, JsonVariant **ret);
