/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

const kPrefCustomizationNavBarWhenVerticalTabs =
  "browser.uiCustomization.navBarWhenVerticalTabs";
const tabsToolbar = "TabsToolbar";
const navBar = "nav-bar";

add_setup(async () => {
  Services.prefs.setCharPref(kPrefCustomizationNavBarWhenVerticalTabs, "");
  await SpecialPowers.pushPrefEnv({
    set: [["sidebar.revamp", true]],
  });
});

registerCleanupFunction(async () => {
  await SpecialPowers.popPrefEnv();
  gBrowser.removeAllTabsBut(gBrowser.tabs[0]);
});

// When switching to vertical tabs, the nav-bar customizations remain the same
// as when in horizontal tabs mode, with the addition of tab strip widgets
// This test asserts we remember any tab strip widget customizations in the nav-bar
// when switching between vertical and horizontal modes
add_task(async function () {
  let defaultHorizontalAllTabsPlacement =
    CustomizableUI.getPlacementOfWidget("alltabs-button");
  let defaultHorizontalIceCatViewPlacement =
    CustomizableUI.getPlacementOfWidget("icecat-view-button");
  is(
    defaultHorizontalAllTabsPlacement.area,
    tabsToolbar,
    `alltabs-button is in the ${tabsToolbar}`
  );
  is(
    defaultHorizontalIceCatViewPlacement.area,
    tabsToolbar,
    `icecat-view-button is in the ${tabsToolbar}`
  );
  info(
    `alltabs-button is in its original default position ${defaultHorizontalAllTabsPlacement.position} for horizontal tabs mode`
  );
  info(
    `icecat-view-button is in its original default position ${defaultHorizontalIceCatViewPlacement.position} for horizontal tabs mode`
  );

  await SpecialPowers.pushPrefEnv({
    set: [["sidebar.verticalTabs", true]],
  });

  await startCustomizing();
  is(gBrowser.tabs.length, 2, "Should have 2 tabs");

  let nonCustomizingTab = gBrowser.tabContainer.querySelector(
    "tab:not([customizemode=true])"
  );
  let finishedCustomizing = BrowserTestUtils.waitForEvent(
    gNavToolbox,
    "aftercustomization"
  );

  let defaultVerticalAllTabsPlacement =
    CustomizableUI.getPlacementOfWidget("alltabs-button");
  let defaultVerticalIceCatViewPlacement = CustomizableUI.getPlacementOfWidget(
    "icecat-view-button"
  );
  is(
    defaultVerticalAllTabsPlacement.area,
    navBar,
    `alltabs-button is in the ${navBar}`
  );
  is(
    defaultVerticalIceCatViewPlacement.area,
    navBar,
    `icecat-view-button is in the ${navBar}`
  );
  info(
    `alltabs-button is in its original default position ${defaultVerticalAllTabsPlacement.position} for vertical tabs mode`
  );
  info(
    `icecat-view-button is in its original default position ${defaultVerticalIceCatViewPlacement.position} for vertical tabs mode`
  );

  let customAllTabsPosition = 1;
  let customIceCatViewPosition = 2;
  CustomizableUI.moveWidgetWithinArea("alltabs-button", customAllTabsPosition);
  CustomizableUI.moveWidgetWithinArea(
    "icecat-view-button",
    customIceCatViewPosition
  );

  await BrowserTestUtils.switchTab(gBrowser, nonCustomizingTab);
  await finishedCustomizing;

  let alltabsPlacement = CustomizableUI.getPlacementOfWidget("alltabs-button");
  let icecatViewPlacement = CustomizableUI.getPlacementOfWidget(
    "icecat-view-button"
  );
  is(alltabsPlacement.area, navBar, `alltabs-button is in the ${navBar}`);
  is(
    icecatViewPlacement.area,
    navBar,
    `icecat-view-button is in the ${navBar}`
  );
  isnot(
    defaultVerticalAllTabsPlacement.position,
    alltabsPlacement.position,
    "alltabs-button has been moved from its default position"
  );
  isnot(
    defaultVerticalIceCatViewPlacement.position,
    icecatViewPlacement.position,
    "icecat-view-button has been moved from its default position"
  );
  is(
    alltabsPlacement.position,
    customAllTabsPosition,
    "alltabs-button is in its new custom position"
  );
  is(
    icecatViewPlacement.position,
    customIceCatViewPosition,
    "icecat-view-button is in its new custom position"
  );

  await SpecialPowers.pushPrefEnv({
    set: [["sidebar.verticalTabs", false]],
  });

  let horizontalAlltabsPlacement =
    CustomizableUI.getPlacementOfWidget("alltabs-button");
  let horizontalIceCatViewPlacement = CustomizableUI.getPlacementOfWidget(
    "icecat-view-button"
  );
  is(
    horizontalAlltabsPlacement.area,
    tabsToolbar,
    `alltabs-button is in the ${tabsToolbar}`
  );
  is(
    horizontalIceCatViewPlacement.area,
    tabsToolbar,
    `icecat-view-button is in the ${tabsToolbar}`
  );
  is(
    horizontalAlltabsPlacement.position,
    defaultHorizontalAllTabsPlacement.position,
    "alltabs-button is in its default horizontal mode position"
  );
  is(
    horizontalIceCatViewPlacement.position,
    defaultHorizontalIceCatViewPlacement.position,
    "icecat-view-button is in its default horizontal mode position"
  );

  // Switching from vertical to horizontal and back to vertical, the customization should be remembered
  await SpecialPowers.pushPrefEnv({
    set: [["sidebar.verticalTabs", true]],
  });

  let newAlltabsPlacement =
    CustomizableUI.getPlacementOfWidget("alltabs-button");
  let newIceCatViewPlacement = CustomizableUI.getPlacementOfWidget(
    "icecat-view-button"
  );
  is(newAlltabsPlacement.area, navBar, `alltabs-button is in the ${navBar}`);
  is(
    newIceCatViewPlacement.area,
    navBar,
    `icecat-view-button is in the ${navBar}`
  );
  is(
    newAlltabsPlacement.position,
    customAllTabsPosition,
    "alltabs-button is in its new custom position"
  );
  is(
    newIceCatViewPlacement.position,
    customIceCatViewPosition,
    "icecat-view-button is in its new custom position"
  );
});
