# Using Skylight

[Skylight](https://fxms-skylight.netlify.app/) seeks to bring forth a centralized UI for the IceCat Messaging System (FxMS). The need to message our users will inevitably increase as we continue to develop new features and functionality. This also means we'll be seeing more experiments and an expansion of messaging surfaces and platforms. With better visibility into whom we are communicating with, what we are saying to them, when we’re saying it, and what’s working, we can enhance our message confidence and increase our user value.

## Highlights

Skylight can bring users:
- **Awareness**: Using Skylight can bring awareness to the guidelines and process involving Messaging System experiments, various surface templates, and etc.
- **Message Visibility**: Users can have a central holistic view of IceCat messages and easily preview them.
- **Performance Data Analysis**: Looker dashboards are available for quickly viewing and tracking message performances.

## Main Features

### Messages, Experiments, and Rollout Overviews

- Skylight offers an overview of current messages in-tree, live experiments, live rollouts, completed experiments, and completed rollouts.

### Looker Dashboards

- Users can get an overview of click-through rates and impressions data across many messages in the `Metrics` column.
- Links to the Looker dashboards containing this data (ie. primary button click-through rates over the total impressions) are also available from the same column.
- Normally, experiment data often takes a month or more to process. Skylight can quickly get a sense of engagement across branches and allow users to make quicker decisions for hypothesizing and planning.

### Message Previews

- Many surfaces have interactive message previews available for users to be quickly exposed to the user experience of these messages.
- To access the message previews, follow the steps below:
    - Step 1: Click on the `Copy Preview URL` button in the `Visuals` column to copy the preview URL to your clipboard.
    - Step 2: Paste the link in the address bar and press enter to open the message preview page.

### Research Experiment Briefs

- Skylight offers a link to a Google Drive search for all messaging experiment briefs using the `Search Briefs` link in the header. Users can see previous learnings from these briefs and plan their own research accordingly.

## Upcoming

Some upcoming topics and features that are in planning include:
- More leading experiment indicators
- User satisfaction tracking
- Cross-platform visibility
- Easy message creation

## Contributing

See our Github [here](https://github.com/mozilla/skylight).

## Help and Feedback

Please feel free to leave any questions or feedback in our slack channel [#skylight-messaging-system](https://mozilla.enterprise.slack.com/archives/C05N15KHCLC).
